<?php

namespace App\Models\User\Request;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Request extends Model 
{

    protected $table = 'user_request_request';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function request()
    {
        return $this->belongsToMany('App\Models\User\Request2', 'user_request_id');
    }

    public function contributors()
    {
        return $this->belongsToMany('App\Models\User', 'user_id');
    }

}